"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateSpotWalletBalance = updateSpotWalletBalance;
const db_1 = require("@b/db");
/**
 * Updates spot wallet balance based on deposit, withdrawal, or refund
 * @param userId - User ID
 * @param currency - Currency code
 * @param amount - Transaction amount
 * @param fee - Transaction fee
 * @param type - Transaction type (DEPOSIT, WITHDRAWAL, REFUND_WITHDRAWAL)
 * @param ctx - Optional logging context
 * @returns Updated wallet object or Error
 */
async function updateSpotWalletBalance(userId, currency, amount, fee, type, ctx) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
    try {
        (_a = ctx === null || ctx === void 0 ? void 0 : ctx.step) === null || _a === void 0 ? void 0 : _a.call(ctx, `Finding wallet for user ${userId}, currency ${currency}`);
        const wallet = await db_1.models.wallet.findOne({
            where: { userId: userId, currency: currency, type: "SPOT" },
        });
        if (!wallet) {
            const errorMsg = "Wallet not found";
            (_b = ctx === null || ctx === void 0 ? void 0 : ctx.fail) === null || _b === void 0 ? void 0 : _b.call(ctx, errorMsg);
            return new Error(errorMsg);
        }
        (_c = ctx === null || ctx === void 0 ? void 0 : ctx.step) === null || _c === void 0 ? void 0 : _c.call(ctx, `Calculating new balance for ${type} operation`);
        let balance;
        switch (type) {
            case "WITHDRAWAL":
                balance = wallet.balance - (amount + fee);
                (_d = ctx === null || ctx === void 0 ? void 0 : ctx.step) === null || _d === void 0 ? void 0 : _d.call(ctx, `Withdrawal: ${wallet.balance} - (${amount} + ${fee}) = ${balance}`);
                break;
            case "DEPOSIT":
                balance = wallet.balance + (amount - fee);
                (_e = ctx === null || ctx === void 0 ? void 0 : ctx.step) === null || _e === void 0 ? void 0 : _e.call(ctx, `Deposit: ${wallet.balance} + (${amount} - ${fee}) = ${balance}`);
                break;
            case "REFUND_WITHDRAWAL":
                balance = wallet.balance + amount + fee;
                (_f = ctx === null || ctx === void 0 ? void 0 : ctx.step) === null || _f === void 0 ? void 0 : _f.call(ctx, `Refund: ${wallet.balance} + ${amount} + ${fee} = ${balance}`);
                break;
            default:
                break;
        }
        if (balance < 0) {
            const errorMsg = "Insufficient balance";
            (_g = ctx === null || ctx === void 0 ? void 0 : ctx.fail) === null || _g === void 0 ? void 0 : _g.call(ctx, errorMsg);
            throw new Error(errorMsg);
        }
        (_h = ctx === null || ctx === void 0 ? void 0 : ctx.step) === null || _h === void 0 ? void 0 : _h.call(ctx, `Updating wallet balance to ${balance}`);
        await db_1.models.wallet.update({ balance: balance }, { where: { id: wallet.id } });
        const updatedWallet = await db_1.models.wallet.findByPk(wallet.id);
        if (!updatedWallet) {
            const errorMsg = "Wallet not found after update";
            (_j = ctx === null || ctx === void 0 ? void 0 : ctx.fail) === null || _j === void 0 ? void 0 : _j.call(ctx, errorMsg);
            throw new Error(errorMsg);
        }
        (_k = ctx === null || ctx === void 0 ? void 0 : ctx.success) === null || _k === void 0 ? void 0 : _k.call(ctx, `Successfully updated wallet balance to ${balance} ${currency}`);
        return updatedWallet.get({ plain: true });
    }
    catch (error) {
        (_l = ctx === null || ctx === void 0 ? void 0 : ctx.fail) === null || _l === void 0 ? void 0 : _l.call(ctx, error.message);
        throw error;
    }
}
